/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.server;

import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.apps.server.util.prefs.WcmWorkplaceConfig;
import com.filenet.wcm.toolkit.server.util.WcmDataStore;
import com.filenet.wcm.toolkit.server.util.WcmServerCredentials;
import com.filenet.wcm.toolkit.server.util.prefs.WcmBootstrapPrefs;
import com.filenet.wcm.toolkit.server.util.prefs.WcmConfiguration;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.Configuration;
import filenet.vw.soap.server.VWNoConnectionPointInSitePref;
import filenet.vw.soap.server.VWSOAPSessionInfo;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class VWPreferencesHelper {
    private static final Logger logger = Logger.getLogger("filenet.vw.soap.server");
    private static final String m_className = "VWPreferencesHelper";
    private static final String CONFIGURATION_KEY = "_myConfigurationKey";

    public static String[] getConfiguredConnectionPoints(ServletContext application, HttpServletRequest request) throws VWException {
        String[] result;
        block9: {
            String method = "getConfiguredConnectionPoints";
            result = new String[1];
            try {
                WcmSitePrefs sitePrefs;
                String routerURL;
                logger.entering(m_className, method);
                WcmDataStore dataStore = WcmDataStore.get((ServletContext)application, (HttpServletRequest)request);
                WcmWorkplaceConfig config = (WcmWorkplaceConfig)dataStore.getValue(CONFIGURATION_KEY);
                if (config == null) {
                    WcmBootstrapPrefs bootstrap = WcmConfiguration.getBootstrapPrefs();
                    config = new WcmWorkplaceConfig(dataStore, bootstrap.getPrefsObjectStoreName(), bootstrap.getApplicationName(), Locale.getDefault());
                    dataStore.setValue(CONFIGURATION_KEY, (Object)config);
                }
                if ((routerURL = (sitePrefs = config.getSitePrefs()).getConnectionPoint()) != null && routerURL.length() > 0) {
                    result[0] = routerURL;
                    if (logger.isFinest()) {
                        logger.finest(m_className, method, "adding routerURL = " + result[0]);
                    }
                    break block9;
                }
                throw new VWNoConnectionPointInSitePref();
            }
            catch (VWNoConnectionPointInSitePref vwe) {
                throw vwe;
            }
            catch (Exception ex) {
                throw new VWException(ex);
            }
            finally {
                logger.exiting(m_className, method);
            }
        }
        return result;
    }

    public static String getConfiguredSimEngUrl(ServletContext application, HttpServletRequest request) throws Exception {
        String method = "getConfiguredSimEngUrl";
        String result = null;
        try {
            logger.entering(m_className, method);
            WcmDataStore dataStore = WcmDataStore.get((ServletContext)application, (HttpServletRequest)request);
            WcmWorkplaceConfig config = (WcmWorkplaceConfig)dataStore.getValue(CONFIGURATION_KEY);
            if (config == null) {
                WcmBootstrapPrefs bootstrap = WcmConfiguration.getBootstrapPrefs();
                config = new WcmWorkplaceConfig(dataStore, bootstrap.getPrefsObjectStoreName(), bootstrap.getApplicationName(), Locale.getDefault());
                dataStore.setValue(CONFIGURATION_KEY, (Object)config);
            }
            WcmSitePrefs sitePrefs = config.getSitePrefs();
            result = "rmi://" + sitePrefs.getSimulatorEngineHost();
            if (result != null && logger.isFinest()) {
                logger.finest(m_className, method, "adding SimEngUrl = " + result);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            logger.exiting(m_className, method);
        }
        return result;
    }

    public static VWSOAPSessionInfo getSessionInfoFromWorkplace(ServletContext application, HttpServletRequest request) throws Exception {
        String m_method = "getSessionInfoFromWorkplace";
        WcmDataStore ds = WcmDataStore.get((ServletContext)application, (HttpServletRequest)request);
        WcmServerCredentials cred = (WcmServerCredentials)ds.getValue("global.userCredentials");
        if (cred == null) {
            VWException ve = new VWException("VWSOAPSessionInfo.verifyCredentials1", "Credentials are not available.");
            logger.throwing(m_className, m_method, ve);
            throw ve;
        }
        Session session = cred.getSession();
        if (session == null) {
            VWException ve = new VWException("VWSOAPSessionInfo.verifyCredentials2", "Session not available.");
            logger.throwing(m_className, m_method, ve);
            throw ve;
        }
        String ceURI = Configuration.NormalizeCEURI(session.getRemoteServerUrl());
        String user = null;
        String password = null;
        boolean isContainerJAASMode = false;
        try {
            isContainerJAASMode = cred.isContainerJAASMode();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!isContainerJAASMode) {
            user = cred.getRawUserId();
            password = cred.getPassword();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "CEURI=" + ceURI + ",  User=" + user);
            }
        } else if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Using ContainerJAASMode");
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "retrieving connection point from Site Preference");
        }
        String[] cps = VWPreferencesHelper.getConfiguredConnectionPoints(application, request);
        return new VWSOAPSessionInfo(user, password, ceURI, cps);
    }
}

